/*
 * Decompiled with CFR 0.152.
 */
package pcl.opensecurity.common.tileentity;

import li.cil.oc.api.API;
import li.cil.oc.api.Network;
import li.cil.oc.api.fs.FileSystem;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.Component;
import li.cil.oc.api.network.ComponentConnector;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.EnvironmentHost;
import li.cil.oc.api.network.ManagedEnvironment;
import li.cil.oc.api.network.Message;
import li.cil.oc.api.network.Node;
import li.cil.oc.api.network.Visibility;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pcl.opensecurity.OpenSecurity;

public class TileEntityOSBase
extends TileEntity
implements ITickable,
ManagedEnvironment {
    public ComponentConnector node;
    private ManagedEnvironment oc_fs;
    protected EnvironmentHost container;
    private final String componentName;
    protected boolean isUpgrade = false;

    public TileEntityOSBase(String name) {
        this.componentName = name;
    }

    public TileEntityOSBase(String name, EnvironmentHost host) {
        this.isUpgrade = true;
        this.componentName = name;
        this.container = host;
        this.setupNode();
    }

    public void func_73660_a() {
        if (this.node() != null && this.node().network() == null) {
            Network.joinOrCreateNetwork((TileEntity)this);
        }
    }

    protected ManagedEnvironment oc_fs() {
        return this.oc_fs;
    }

    protected void initOCFilesystem(String path, String name) {
        this.oc_fs = li.cil.oc.api.FileSystem.asManagedEnvironment((FileSystem)li.cil.oc.api.FileSystem.fromClass(OpenSecurity.class, (String)"opensecurity", (String)path), (String)name);
        ((Component)this.oc_fs().node()).setVisibility(Visibility.Network);
    }

    protected String getComponentName() {
        return this.componentName;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        if (!this.isUpgrade) {
            super.func_145839_a(nbt);
        }
        if (this.node() != null && this.node().host() == this) {
            this.node().load(nbt.func_74775_l("oc:node"));
        }
        if (this.oc_fs() != null && this.oc_fs().node() != null) {
            this.oc_fs().node().load(nbt.func_74775_l("oc:fs"));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        if (!this.isUpgrade) {
            nbt = super.func_189515_b(nbt);
        }
        if (this.node() != null && this.node().host() == this) {
            NBTTagCompound nodeNbt = new NBTTagCompound();
            this.node().save(nodeNbt);
            nbt.func_74782_a("oc:node", (NBTBase)nodeNbt);
        }
        if (this.oc_fs() != null && this.oc_fs().node() != null) {
            NBTTagCompound fsNbt = new NBTTagCompound();
            this.oc_fs().node().save(fsNbt);
            nbt.func_74782_a("oc:fs", (NBTBase)fsNbt);
        }
        return nbt;
    }

    @Callback
    public Object[] greet(Context context, Arguments args) {
        return new Object[]{"Lasciate ogne speranza, voi ch'entrate"};
    }

    public Node node() {
        return this.node;
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.node != null) {
            this.node.remove();
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.node != null) {
            this.node.remove();
        }
    }

    public void onConnect(Node arg0) {
    }

    public void onDisconnect(Node node) {
    }

    public void onMessage(Message arg0) {
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(super.func_189517_E_());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, this.func_189517_E_());
    }

    @SideOnly(value=Side.CLIENT)
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        this.func_145839_a(tag);
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    public void setupNode() {
        if (this.node() == null) {
            this.node = (ComponentConnector)API.network.newNode((Environment)this, Visibility.Neighbors).withConnector().withComponent(this.getComponentName()).create();
        }
    }

    public boolean canUpdate() {
        return false;
    }

    public void load(NBTTagCompound nbt) {
        this.setupNode();
        this.func_145839_a(nbt);
    }

    public void save(NBTTagCompound nbt) {
        this.setupNode();
        nbt = this.func_189515_b(nbt);
    }

    public World func_145831_w() {
        if (this.isUpgrade) {
            return this.container.world();
        }
        return super.func_145831_w();
    }

    public BlockPos func_174877_v() {
        if (this.isUpgrade) {
            return new BlockPos(this.container.xPosition(), this.container.yPosition(), this.container.zPosition());
        }
        return super.func_174877_v();
    }
}

