/*
 * Decompiled with CFR 0.152.
 */
package pcl.opensecurity.common.nanofog;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class EntityFilter {
    private HashMap<String, HashSet<String>> list = new HashMap();

    public void add(Class entityClass, String entityName) {
        String className = entityClass.getSimpleName();
        this.list.putIfAbsent(className, new HashSet());
        if (entityName.length() > 0) {
            this.list.get(className).add(entityName.toLowerCase());
        }
    }

    public void remove(Class entityClass, String entityName) {
        String className = entityClass.getSimpleName();
        if (!this.list.containsKey(className)) {
            return;
        }
        if (entityName.length() > 0) {
            this.list.get(className).remove(entityName.toLowerCase());
        } else if (this.list.get(className).size() == 0) {
            this.list.remove(className);
        }
    }

    public boolean contains(Class entityClass, String entityName) {
        String className;
        switch (className = entityClass.getSimpleName()) {
            case "EntityPlayerSP": 
            case "EntityPlayerMP": {
                className = "EntityPlayer";
                break;
            }
        }
        if (!this.list.containsKey(className)) {
            return false;
        }
        HashSet<String> subList = this.list.get(className);
        return subList == null || subList.size() == 0 || subList.contains(entityName.toLowerCase());
    }

    public HashMap<String, HashSet<String>> getList() {
        return this.list;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        int cI = 0;
        for (Map.Entry<String, HashSet<String>> entry : this.list.entrySet()) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("class", entry.getKey());
            int nI = 0;
            for (String name : entry.getValue()) {
                tag.func_74778_a("n" + nI++, name);
            }
            nbt.func_74782_a("c" + cI++, (NBTBase)tag);
        }
        return nbt;
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.list.clear();
        int cI = 0;
        while (nbt.func_74764_b("c" + cI)) {
            NBTTagCompound tag = nbt.func_74775_l("c" + cI);
            HashSet<String> names = new HashSet<String>();
            int nI = 0;
            while (tag.func_74764_b("n" + nI)) {
                names.add(tag.func_74779_i("n" + nI));
                ++nI;
            }
            this.list.put(tag.func_74779_i("class"), names);
            ++cI;
        }
    }
}

