/*
 * Decompiled with CFR 0.152.
 */
package pcl.opensecurity.common.blocks;

import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import pcl.opensecurity.common.ContentRegistry;
import pcl.opensecurity.common.items.ItemSecureDoor;
import pcl.opensecurity.common.protection.Protection;
import pcl.opensecurity.common.tileentity.TileEntitySecureDoor;

public class BlockSecureDoor
extends BlockDoor {
    public static final String NAME = "secure_door";
    public static BlockSecureDoor DEFAULTITEM;

    public BlockSecureDoor() {
        this(NAME);
    }

    BlockSecureDoor(String name) {
        super(Material.field_151573_f);
        this.setRegistryName("opensecurity", name);
        this.func_149663_c(name);
        this.func_149647_a(ContentRegistry.creativeTab);
    }

    @Nonnull
    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack(this.func_176509_j());
    }

    @Nonnull
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return state.func_177229_b((IProperty)field_176523_O) == BlockDoor.EnumDoorHalf.UPPER ? Items.field_190931_a : this.func_176509_j();
    }

    protected Item func_176509_j() {
        return ItemSecureDoor.DEFAULTSTACK.func_77973_b();
    }

    @Nonnull
    public MapColor func_180659_g(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return this.field_181083_K;
    }

    @Nonnull
    public String func_149732_F() {
        return new TextComponentTranslation(this.func_149739_a() + ".name", new Object[0]).func_150260_c();
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        return new TileEntitySecureDoor();
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (!player.func_184812_l_()) {
            if (Protection.isProtected((Entity)player, Protection.UserAction.mine, pos)) {
                return false;
            }
            TileEntity te = world.func_175625_s(pos);
            if (te instanceof TileEntitySecureDoor && !((TileEntitySecureDoor)te).getOwner().equals(player.func_110124_au())) {
                return false;
            }
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public static BlockPos getOtherDoorPart(World world, BlockPos thisPos) {
        if (world.func_175625_s(new BlockPos(thisPos.func_177958_n(), thisPos.func_177956_o() + 1, thisPos.func_177952_p())) instanceof TileEntitySecureDoor) {
            return new BlockPos(thisPos.func_177958_n(), thisPos.func_177956_o() + 1, thisPos.func_177952_p());
        }
        return new BlockPos(thisPos.func_177958_n(), thisPos.func_177956_o() - 1, thisPos.func_177952_p());
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (state.func_177229_b((IProperty)field_176523_O) == BlockDoor.EnumDoorHalf.UPPER) {
            BlockPos blockpos = pos.func_177977_b();
            IBlockState iblockstate = worldIn.func_180495_p(blockpos);
            if (iblockstate.func_177230_c() != this) {
                worldIn.func_175698_g(pos);
            } else if (blockIn != this) {
                iblockstate.func_189546_a(worldIn, blockpos, blockIn, fromPos);
            }
        } else {
            boolean flag1 = false;
            BlockPos blockpos1 = pos.func_177984_a();
            IBlockState iblockstate1 = worldIn.func_180495_p(blockpos1);
            if (iblockstate1.func_177230_c() != this) {
                worldIn.func_175698_g(pos);
                flag1 = true;
            }
            if (!worldIn.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP)) {
                worldIn.func_175698_g(pos);
                flag1 = true;
                if (iblockstate1.func_177230_c() == this) {
                    worldIn.func_175698_g(blockpos1);
                }
            }
            if (flag1 && !worldIn.field_72995_K) {
                this.func_176226_b(worldIn, pos, state, 0);
            }
        }
    }
}

