/*
 * Decompiled with CFR 0.152.
 */
package pcl.opensecurity.client;

import java.io.File;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.tileentity.TileEntityItemStackRenderer;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pcl.opensecurity.Config;
import pcl.opensecurity.OpenSecurity;
import pcl.opensecurity.client.CamouflageBlockModelLoader;
import pcl.opensecurity.client.models.ModelNanoFogSwarm;
import pcl.opensecurity.client.renderer.EnergyTurretRenderHelper;
import pcl.opensecurity.client.renderer.NanoFogSwarmRenderer;
import pcl.opensecurity.client.renderer.RenderEnergyTurret;
import pcl.opensecurity.client.renderer.RenderEntityEnergyBolt;
import pcl.opensecurity.client.renderer.RenderKeypad;
import pcl.opensecurity.client.renderer.RenderRolldoorController;
import pcl.opensecurity.client.renderer.SecurityTerminalRender;
import pcl.opensecurity.client.sounds.AlarmResource;
import pcl.opensecurity.common.CommonProxy;
import pcl.opensecurity.common.ContentRegistry;
import pcl.opensecurity.common.blocks.BlockCamouflage;
import pcl.opensecurity.common.blocks.BlockDoorController;
import pcl.opensecurity.common.blocks.BlockNanoFog;
import pcl.opensecurity.common.blocks.BlockRolldoor;
import pcl.opensecurity.common.blocks.BlockRolldoorController;
import pcl.opensecurity.common.blocks.BlockRolldoorElement;
import pcl.opensecurity.common.blocks.BlockSecureDoor;
import pcl.opensecurity.common.blocks.BlockSecurePrivateDoor;
import pcl.opensecurity.common.entity.EntityEnergyBolt;
import pcl.opensecurity.common.entity.EntityNanoFogSwarm;
import pcl.opensecurity.common.items.ItemCard;
import pcl.opensecurity.common.items.ItemMagCard;
import pcl.opensecurity.common.items.ItemRFIDCard;
import pcl.opensecurity.common.tileentity.TileEntityEnergyTurret;
import pcl.opensecurity.common.tileentity.TileEntityKeypad;
import pcl.opensecurity.common.tileentity.TileEntityRolldoorController;
import pcl.opensecurity.util.FileUtils;

@SideOnly(value=Side.CLIENT)
public class ClientProxy
extends CommonProxy {
    @SubscribeEvent
    public void renderWorldLastEvent(RenderWorldLastEvent evt) {
        SecurityTerminalRender.showFoundTerminals(evt);
    }

    @SubscribeEvent
    public void colorHandlerEventBlock(ColorHandlerEvent.Block event) {
        BlockNanoFog.DEFAULTITEM.initColorHandler(event.getBlockColors());
        BlockDoorController.DEFAULTITEM.initColorHandler(event.getBlockColors());
        BlockRolldoorController.DEFAULTITEM.initColorHandler(event.getBlockColors());
        BlockRolldoor.DEFAULTITEM.initColorHandler(event.getBlockColors());
    }

    @Override
    public World getWorld(int dimId) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        return world.field_73011_w.getDimension() == dimId ? world : null;
    }

    @Override
    public void preinit() {
        super.preinit();
        Config.clientPreInit();
        ModelNanoFogSwarm.setupResolution(Config.getConfig().getCategory("client").get("nanoFogSwarmResolution").getInt());
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)new CamouflageBlockModelLoader());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityKeypad.class, (TileEntitySpecialRenderer)new RenderKeypad());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityRolldoorController.class, (TileEntitySpecialRenderer)new RenderRolldoorController());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityEnergyTurret.class, (TileEntitySpecialRenderer)new RenderEnergyTurret());
        TileEntityItemStackRenderer.field_147719_a = new EnergyTurretRenderHelper();
        RenderingRegistry.registerEntityRenderingHandler(EntityEnergyBolt.class, RenderEntityEnergyBolt::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityNanoFogSwarm.class, (IRenderFactory)NanoFogSwarmRenderer.FACTORY);
        if (OpenSecurity.debug) {
            OpenSecurity.logger.info("Registered renderers/models");
        }
    }

    @Override
    public void init() {
        super.init();
        Minecraft mc = Minecraft.func_71410_x();
        mc.getItemColors().func_186730_a((IItemColor)new CardColorHandler(), new Item[]{ItemRFIDCard.DEFAULTSTACK.func_77973_b()});
        mc.getItemColors().func_186730_a((IItemColor)new CardColorHandler(), new Item[]{ItemMagCard.DEFAULTSTACK.func_77973_b()});
    }

    @Override
    public void registerModels() {
        for (Block block : ContentRegistry.modBlocks) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)block), (int)0, (ModelResourceLocation)new ModelResourceLocation(block.getRegistryName().toString(), "inventory"));
        }
        for (Block block : ContentRegistry.modCamoBlocks) {
            CamouflageBlockModelLoader.registerBlock((BlockCamouflage)block);
        }
        for (ItemStack itemStack : ContentRegistry.modBlocksWithItem.values()) {
            ModelLoader.setCustomModelResourceLocation((Item)itemStack.func_77973_b(), (int)0, (ModelResourceLocation)new ModelResourceLocation(itemStack.func_77973_b().getRegistryName().toString()));
        }
        for (ItemStack itemStack : ContentRegistry.modItems) {
            ModelLoader.setCustomModelResourceLocation((Item)itemStack.func_77973_b(), (int)0, (ModelResourceLocation)new ModelResourceLocation(itemStack.func_77973_b().getRegistryName().toString()));
        }
        ModelLoader.setCustomStateMapper((Block)BlockRolldoorElement.DEFAULTITEM, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockRolldoorElement.PROPERTYOFFSET}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)BlockSecureDoor.DEFAULTITEM, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockDoor.field_176522_N}).func_178441_a());
        ModelLoader.setCustomStateMapper((Block)BlockSecurePrivateDoor.DEFAULTITEM, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockDoor.field_176522_N}).func_178441_a());
    }

    private void listFilesForPath(File path) {
        AlarmResource r = new AlarmResource();
        int i = 1;
        for (File fileEntry : FileUtils.listFilesForPath(path.getPath())) {
            r.addSoundReferenceMapping(i++, fileEntry.getName());
        }
        r.registerAsResourceLocation();
    }

    @Override
    public void registerSounds() {
        File alarmSounds = new File("./mods/OpenSecurity/assets/opensecurity/sounds/alarms");
        if (!alarmSounds.exists()) {
            return;
        }
        for (File file : alarmSounds.listFiles()) {
            if (!file.isFile()) continue;
            OpenSecurity.alarmList.add(file.getName());
        }
        this.listFilesForPath(alarmSounds);
    }

    private static class CardColorHandler
    implements IItemColor {
        private CardColorHandler() {
        }

        public int func_186726_a(ItemStack stack, int tintIndex) {
            return tintIndex == 0 ? 0xFFFFFF : new ItemCard.CardTag((NBTTagCompound)stack.func_77978_p()).color;
        }
    }
}

