/*
 * Decompiled with CFR 0.152.
 */
package twistedgate.immersiveposts.enums;

import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.metal.BlockTypes_MetalDecoration1;
import blusunrize.immersiveengineering.common.blocks.wooden.BlockTypes_WoodenDecoration;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import twistedgate.immersiveposts.IPOStuff;
import twistedgate.immersiveposts.common.blocks.BlockPost;
import twistedgate.immersiveposts.enums.EnumPostType;

public enum EnumPostMaterial implements IStringSerializable
{
    WOOD("woodpost", (Block)IEContent.blockWoodenDecoration, BlockTypes_WoodenDecoration.FENCE.getMeta()),
    NETHERBRICK("netherpost", Blocks.field_150386_bk),
    IRON("ironpost", (Block)IPOStuff.ironFence),
    GOLD("goldpost", (Block)IPOStuff.goldFence),
    COPPER("copperpost", (Block)IPOStuff.copperFence),
    LEAD("leadpost", (Block)IPOStuff.leadFence),
    SILVER("silverpost", (Block)IPOStuff.silverFence),
    NICKEL("nickelpost", (Block)IPOStuff.nickelFence),
    CONSTANTAN("constantanpost", (Block)IPOStuff.constantanFence),
    ELECTRUM("electrumpost", (Block)IPOStuff.electrumFence),
    URANIUM("uraniumpost", (Block)IPOStuff.uraniumFence),
    ALUMINIUM("aluminiumpost", (Block)IEContent.blockMetalDecoration1, BlockTypes_MetalDecoration1.ALUMINUM_FENCE.getMeta()),
    STEEL("steelpost", (Block)IEContent.blockMetalDecoration1, BlockTypes_MetalDecoration1.STEEL_FENCE.getMeta());

    private final String name;
    private final Block fenceBlock;
    private final int fenceMeta;

    private EnumPostMaterial(String name, Block fenceBlock) {
        this(name, fenceBlock, 0);
    }

    private EnumPostMaterial(String name, Block fenceBlock, int fenceMeta) {
        this.name = name;
        this.fenceBlock = fenceBlock;
        this.fenceMeta = fenceMeta;
    }

    public ItemStack getFenceItem() {
        return new ItemStack(this.fenceBlock, 1, this.fenceMeta);
    }

    public Block getFenceBlock() {
        return this.fenceBlock;
    }

    public int getFenceMeta() {
        return this.fenceMeta;
    }

    public String func_176610_l() {
        return this.name;
    }

    public static IBlockState getPostStateFrom(ItemStack stack) {
        IBlockState state = null;
        switch (EnumPostMaterial.getFrom(stack)) {
            case ALUMINIUM: {
                state = IPOStuff.aluPost.func_176223_P();
                break;
            }
            case CONSTANTAN: {
                state = IPOStuff.constantanPost.func_176223_P();
                break;
            }
            case COPPER: {
                state = IPOStuff.copperPost.func_176223_P();
                break;
            }
            case ELECTRUM: {
                state = IPOStuff.electrumPost.func_176223_P();
                break;
            }
            case GOLD: {
                state = IPOStuff.goldPost.func_176223_P();
                break;
            }
            case IRON: {
                state = IPOStuff.ironPost.func_176223_P();
                break;
            }
            case LEAD: {
                state = IPOStuff.leadPost.func_176223_P();
                break;
            }
            case NETHERBRICK: {
                state = IPOStuff.netherPost.func_176223_P();
                break;
            }
            case NICKEL: {
                state = IPOStuff.nickelPost.func_176223_P();
                break;
            }
            case SILVER: {
                state = IPOStuff.silverPost.func_176223_P();
                break;
            }
            case STEEL: {
                state = IPOStuff.steelPost.func_176223_P();
                break;
            }
            case URANIUM: {
                state = IPOStuff.uraniumPost.func_176223_P();
                break;
            }
            case WOOD: {
                state = IPOStuff.woodPost.func_176223_P();
            }
        }
        return state != null ? state.func_177226_a(BlockPost.TYPE, (Comparable)((Object)EnumPostType.POST_TOP)) : null;
    }

    public static EnumPostMaterial getFrom(ItemStack stack) {
        for (EnumPostMaterial mat : EnumPostMaterial.values()) {
            if (!stack.func_77969_a(mat.getFenceItem())) continue;
            return mat;
        }
        return null;
    }

    public static boolean isFenceItem(ItemStack stack) {
        if (stack == null || stack.func_190926_b()) {
            return false;
        }
        for (EnumPostMaterial mat : EnumPostMaterial.values()) {
            if (!stack.func_77969_a(mat.getFenceItem())) continue;
            return true;
        }
        return false;
    }
}

