/*
 * Decompiled with CFR 0.152.
 */
package pcl.opensecurity.common.tileentity;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import li.cil.oc.api.Network;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.ComponentConnector;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.EnvironmentHost;
import li.cil.oc.api.network.Visibility;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pcl.opensecurity.common.interfaces.IColoredTile;
import pcl.opensecurity.common.interfaces.IPasswordProtected;
import pcl.opensecurity.common.tileentity.TileEntityOSCamoBase;
import pcl.opensecurity.common.tileentity.TileEntityRolldoor;
import pcl.opensecurity.common.tileentity.logic.RolldoorHelper;
import pcl.opensecurity.lib.easing.penner.Quad;

public class TileEntityRolldoorController
extends TileEntityOSCamoBase
implements IPasswordProtected,
IColoredTile {
    private static final double MAX_MOVE_SPEED = 3.0;
    private static final double MIN_MOVE_SPEED = 0.1;
    static final String NAME = "os_rolldoorcontroller";
    private String password = "";
    private int color = 0;
    private AxisAlignedBB renderBoundingBox;
    private AxisAlignedBB elementsRenderBoundingBox = this.renderBoundingBox = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    private EnumFacing facing = EnumFacing.NORTH;
    private double currentPosition = 0.0;
    private double targetPosition = -1.0;
    private double moveSpeed = 1.0;
    private HashSet<WeakReference<TileEntityRolldoor>> elements = new HashSet();
    private HashSet<BlockPos> elementsPos = new HashSet();
    private boolean needsListUpdate = false;
    private long animationStart = 0L;
    private long animationEnd = 0L;
    private long animationDuration = 0L;
    private double animationDistance = 0.0;
    private double animationStartPosition = 0.0;
    private double animationTargetPosition = -1.0;

    public TileEntityRolldoorController() {
        super(NAME);
        this.node = (ComponentConnector)Network.newNode((Environment)this, (Visibility)Visibility.Network).withComponent(this.getComponentName()).withConnector(32.0).create();
    }

    public TileEntityRolldoorController(EnvironmentHost host) {
        super(NAME, host);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.needsListUpdate) {
            this.updateElementList();
        }
        this.getCurrentHeight();
    }

    private void updateElementList() {
        if (this.func_145831_w() == null) {
            return;
        }
        ArrayList<BlockPos> addElements = new ArrayList<BlockPos>(this.elementsPos);
        this.resetRolldoorData();
        for (BlockPos pos : addElements) {
            TileEntity tile = this.func_145831_w().func_175625_s(pos);
            if (!(tile instanceof TileEntityRolldoor)) continue;
            this.addElement((TileEntityRolldoor)tile);
        }
        this.needsListUpdate = false;
        this.markDirtyClient();
    }

    @Callback(doc="function():boolean; returns true if the door is opened", direct=false)
    public Object[] isOpen(Context context, Arguments args) {
        return new Object[]{this.isOpen()};
    }

    @Callback(doc="function():boolean; returns true if the door is moving", direct=true)
    public Object[] isMoving(Context context, Arguments args) {
        return new Object[]{this.isMoving()};
    }

    @Callback(doc="function():double; returns current position", direct=false)
    public Object[] getPosition(Context context, Arguments args) {
        return new Object[]{this.getCurrentHeight()};
    }

    @Callback(doc="function(Double:position):double; sets a new position the rolldoor should move to", direct=false)
    public Object[] setPosition(Context context, Arguments args) {
        double newPos = args.optDouble(0, this.currentPosition);
        if (!this.getPass().equals(args.optString(1, ""))) {
            return new Object[]{false, "invalid password"};
        }
        this.setTargetPosition(Math.max(0.0, Math.min((double)this.getHeight(), newPos)));
        return new Object[]{this.targetPosition};
    }

    @Callback(doc="function():double; toggles the rolldoor between open/close", direct=false)
    public Object[] toggle(Context context, Arguments args) {
        if (!this.getPass().equals(args.optString(0, ""))) {
            return new Object[]{false, "invalid password"};
        }
        if (this.isMoving()) {
            return new Object[]{false, "rolldoor is moving"};
        }
        if (this.isOpen()) {
            this.setTargetPosition(this.getHeight());
            return new Object[]{true, "closing door"};
        }
        this.setTargetPosition(0.0);
        return new Object[]{true, "opening door"};
    }

    @Callback(doc="function():double; opens the rolldoor", direct=false)
    public Object[] open(Context context, Arguments args) {
        if (!this.getPass().equals(args.optString(0, ""))) {
            return new Object[]{false, "invalid password"};
        }
        this.setTargetPosition(0.0);
        return new Object[]{true};
    }

    @Callback(doc="function():double; closes the rolldoor", direct=false)
    public Object[] close(Context context, Arguments args) {
        if (!this.getPass().equals(args.optString(0, ""))) {
            return new Object[]{false, "invalid password"};
        }
        this.setTargetPosition(this.getHeight());
        return new Object[]{true};
    }

    @Callback(doc="function(Double:speed):double; sets the speed of the rolldoor, returns new speed", direct=true)
    public Object[] setSpeed(Context context, Arguments args) {
        if (!this.getPass().equals(args.optString(1, ""))) {
            return new Object[]{false, "invalid password"};
        }
        this.moveSpeed = Math.max(0.1, Math.min(3.0, args.optDouble(0, this.moveSpeed)));
        return new Object[]{this.moveSpeed};
    }

    @Callback(doc="function(String:password):integer; checks for space below the rolldoor, returns new height")
    public Object[] calibrate(Context context, Arguments args) {
        if (!this.getPass().equals(args.optString(0, ""))) {
            return new Object[]{false, "invalid password"};
        }
        for (WeakReference<TileEntityRolldoor> ref : this.elements) {
            if (ref.get() == null || ((TileEntityRolldoor)ref.get()).func_145837_r()) continue;
            ((TileEntityRolldoor)ref.get()).updateHeight();
        }
        return new Object[]{this.getHeight()};
    }

    @Callback(doc="function():integer; returns height of the rolldoor", direct=true)
    public Object[] getHeight(Context context, Arguments args) {
        ArrayList<Integer> heights = new ArrayList<Integer>();
        for (WeakReference<TileEntityRolldoor> ref : this.elements) {
            if (ref.get() == null || ((TileEntityRolldoor)ref.get()).func_145837_r()) continue;
            heights.add(((TileEntityRolldoor)ref.get()).height());
        }
        return new Object[]{heights.toArray()};
    }

    @Callback(doc="function():boolean; sets a password for controlling the door", direct=false)
    public Object[] setPassword(Context context, Arguments args) {
        if (!this.getPass().equals(args.optString(1, ""))) {
            return new Object[]{false, "old password doesnt match"};
        }
        this.setPassword(args.checkString(0));
        return new Object[]{true};
    }

    private void resetRolldoorData() {
        for (WeakReference<TileEntityRolldoor> tile : this.elements) {
            if (tile == null || tile.get() == null || ((TileEntityRolldoor)tile.get()).func_145837_r()) continue;
            ((TileEntityRolldoor)tile.get()).setOrigin(null);
        }
        this.elements.clear();
        this.elementsPos.clear();
        this.elementsRenderBoundingBox = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0).func_186670_a(this.func_174877_v());
        this.renderBoundingBox = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0).func_186670_a(this.func_174877_v());
    }

    public void initialize() {
        this.resetRolldoorData();
        EnumFacing enumFacing = null;
        int yLevel = -1;
        for (TileEntityRolldoor tile : RolldoorHelper.getDoors(this).values()) {
            if (enumFacing == null) {
                enumFacing = tile.getFacing();
            }
            if (yLevel == -1) {
                yLevel = tile.func_174877_v().func_177956_o();
            }
            if (!enumFacing.equals((Object)tile.getFacing()) || tile.func_174877_v().func_177956_o() != yLevel) continue;
            this.addElement(tile);
        }
        this.markDirtyClient();
    }

    public void remove() {
        HashSet<WeakReference<TileEntityRolldoor>> elementsList = new HashSet<WeakReference<TileEntityRolldoor>>();
        elementsList.addAll(this.elements);
        for (WeakReference weakReference : elementsList) {
            if (weakReference.get() == null || ((TileEntityRolldoor)weakReference.get()).func_145837_r()) continue;
            this.removeElement((TileEntityRolldoor)weakReference.get());
        }
    }

    private void addElement(TileEntityRolldoor rolldoor) {
        if (rolldoor == null || rolldoor.func_145837_r()) {
            return;
        }
        if (rolldoor.getController() != null && !this.equals(rolldoor.getController())) {
            return;
        }
        rolldoor.setOrigin(this.func_174877_v());
        this.facing = rolldoor.getFacing();
        this.elementsRenderBoundingBox = this.elements.size() == 0 ? rolldoor.getElementsBoundingBox() : this.elementsRenderBoundingBox.func_111270_a(rolldoor.getElementsBoundingBox());
        this.elements.add(new WeakReference<TileEntityRolldoor>(rolldoor));
        this.elementsPos.add(rolldoor.func_174877_v());
        this.renderBoundingBox = this.renderBoundingBox.func_111270_a(this.elementsRenderBoundingBox);
    }

    private void removeElement(TileEntityRolldoor rolldoor) {
        if (rolldoor != null) {
            rolldoor.setOrigin(null);
        }
        this.initialize();
    }

    @Nonnull
    public AxisAlignedBB getRenderBoundingBox() {
        return this.renderBoundingBox;
    }

    public AxisAlignedBB getElementsRenderBoundingBox() {
        return this.elementsRenderBoundingBox.func_72317_d((double)(-this.func_174877_v().func_177958_n()), (double)(-this.func_174877_v().func_177956_o() - 1), (double)(-this.func_174877_v().func_177952_p()));
    }

    private void startAnimationTo(double newPosition) {
        newPosition = Math.max(0.0, Math.min(newPosition, (double)this.getHeight()));
        this.animationDistance = newPosition - this.currentPosition;
        this.animationStartPosition = this.currentPosition;
        this.animationTargetPosition = this.targetPosition;
        this.animationDuration = Math.round(Math.abs(this.animationDistance / this.moveSpeed) * 1000.0);
        this.animationStart = System.currentTimeMillis();
        this.animationEnd = this.animationStart + this.animationDuration;
    }

    private void endAnimation() {
        this.currentPosition = this.targetPosition;
        this.animationDuration = 0L;
        this.animationEnd = 0L;
        this.animationStart = 0L;
        this.animationDistance = 0.0;
        this.animationStartPosition = 0.0;
        this.targetPosition = -1.0;
    }

    public double getCurrentHeight() {
        long elapsed;
        if (!this.isMoving()) {
            return this.currentPosition;
        }
        if (this.animationEnd == 0L || this.animationTargetPosition != this.targetPosition) {
            this.startAnimationTo(this.targetPosition);
        }
        if ((elapsed = System.currentTimeMillis() - this.animationStart) >= this.animationDuration) {
            this.endAnimation();
            return this.currentPosition;
        }
        this.currentPosition = this.animationStartPosition + this.animationDistance * (double)Math.abs(Quad.easeInOut(elapsed, 0.0f, 1.0f, this.animationDuration));
        return this.currentPosition;
    }

    private void setTargetPosition(double targetPosition) {
        this.targetPosition = targetPosition;
        this.markDirtyClient();
    }

    private boolean isOpen() {
        return this.getCurrentHeight() <= 0.0;
    }

    private boolean isMoving() {
        return this.targetPosition != -1.0;
    }

    private int getHeight() {
        int height = 0;
        for (WeakReference<TileEntityRolldoor> ref : this.elements) {
            if (ref.get() == null || ((TileEntityRolldoor)ref.get()).func_145837_r()) continue;
            height = Math.max(((TileEntityRolldoor)ref.get()).height(), height);
        }
        return height;
    }

    @Override
    public void markDirtyClient() {
        this.func_70296_d();
        if (this.func_145831_w() != null) {
            IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
            this.func_145831_w().func_184138_a(this.func_174877_v(), state, state, 3);
        }
    }

    public int getWidth() {
        return this.elements.size();
    }

    public EnumFacing rolldoorFacing() {
        return this.facing;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.elementsPos.clear();
        int i = 0;
        while (nbt.func_74764_b("el" + i)) {
            this.elementsPos.add(NBTUtil.func_186861_c((NBTTagCompound)nbt.func_74775_l("el" + i)));
            ++i;
        }
        this.facing = EnumFacing.values()[nbt.func_74762_e("rolldoorFacing")];
        this.color = nbt.func_74762_e("color");
        this.moveSpeed = nbt.func_74769_h("moveSpeed");
        this.currentPosition = nbt.func_74769_h("position");
        this.targetPosition = nbt.func_74769_h("targetPos");
        this.password = nbt.func_74779_i("password");
        this.needsListUpdate = true;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        int i = 0;
        for (BlockPos pos : this.elementsPos) {
            nbt.func_74782_a("el" + i, (NBTBase)NBTUtil.func_186859_a((BlockPos)pos));
            ++i;
        }
        nbt.func_74768_a("color", this.color);
        nbt.func_74768_a("rolldoorFacing", this.facing.ordinal());
        nbt.func_74780_a("moveSpeed", this.moveSpeed);
        nbt.func_74780_a("position", this.currentPosition);
        nbt.func_74780_a("targetPos", this.targetPosition);
        nbt.func_74778_a("password", this.password);
        return super.func_189515_b(nbt);
    }

    @Override
    public String getPass() {
        return this.password;
    }

    @Override
    public void setPassword(String newPassword) {
        this.password = newPassword;
    }

    @Override
    public int getColor() {
        return this.color;
    }

    @Override
    public void setColor(int color) {
        if (this.color != color) {
            this.color = color;
            this.onColorChanged();
        }
    }

    @Override
    public void onColorChanged() {
        this.markDirtyClient();
    }

    @Override
    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(super.func_189517_E_());
    }

    @Override
    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, this.func_189517_E_());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }
}

