/*
 * Decompiled with CFR 0.152.
 */
package pcl.opensecurity.common.blocks;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pcl.opensecurity.common.blocks.BlockOSBase;
import pcl.opensecurity.common.camouflage.CamoBlockId;
import pcl.opensecurity.common.camouflage.CamoProperty;
import pcl.opensecurity.common.interfaces.ICamo;

public class BlockCamouflage
extends Block {
    public static final String CAMO = "camo";
    public static final CamoProperty CAMOID = new CamoProperty("camoid");

    public BlockCamouflage(Material materialIn, String name) {
        super(materialIn);
        this.setRegistryName("opensecurity", name);
        this.func_149663_c(name);
    }

    public static ICamo getTE(IBlockAccess world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        return te instanceof ICamo ? (ICamo)te : null;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af()) {
            return false;
        }
        ItemStack heldItem = player.func_184614_ca();
        ICamo tileEntity = BlockCamouflage.getTE((IBlockAccess)world, pos);
        IBlockState currentCamoBlock = tileEntity.getCamoBlock();
        if (currentCamoBlock.equals(Blocks.field_150350_a.func_176223_P()) && state.func_177230_c().equals(Block.func_149634_a((Item)heldItem.func_77973_b()))) {
            return false;
        }
        if (currentCamoBlock.func_177230_c().equals(Block.func_149634_a((Item)heldItem.func_77973_b())) && currentCamoBlock.func_177230_c().func_176201_c(currentCamoBlock) == heldItem.func_77960_j()) {
            return false;
        }
        if (tileEntity.setCamoBlock(player, heldItem)) {
            return true;
        }
        return super.func_180639_a(world, pos, state, player, hand, side, hitX, hitY, hitZ);
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel(final ModelResourceLocation model) {
        StateMapperBase ignoreState = new StateMapperBase(){

            @Nonnull
            protected ModelResourceLocation func_178132_a(@Nonnull IBlockState iBlockState) {
                return model;
            }
        };
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)ignoreState);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return true;
    }

    @Nullable
    protected static IBlockState getMimicBlock(IBlockAccess blockAccess, BlockPos pos) {
        TileEntity te = blockAccess.func_175625_s(pos);
        return te instanceof ICamo ? ((ICamo)te).getCamoBlock() : null;
    }

    @SideOnly(value=Side.CLIENT)
    public void initColorHandler(BlockColors blockColors) {
        blockColors.func_186722_a((state, world, pos, tintIndex) -> {
            IBlockState mimicBlock = BlockCamouflage.getMimicBlock(world, pos);
            if (mimicBlock == null) {
                return -1;
            }
            if (mimicBlock.func_177230_c().equals((Object)this)) {
                return 0;
            }
            return blockColors.func_186724_a(mimicBlock, world, pos, tintIndex);
        }, new Block[]{this});
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[]{BlockOSBase.PROPERTYFACING}, new IUnlistedProperty[]{CAMOID});
    }

    @Nonnull
    public IBlockState getExtendedState(@Nonnull IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.getExtendedStateMimic((IExtendedBlockState)state, world, pos);
    }

    private IExtendedBlockState getExtendedStateMimic(IExtendedBlockState state, IBlockAccess world, BlockPos pos) {
        IBlockState mimicBlock = BlockCamouflage.getMimicBlock(world, pos);
        return mimicBlock != null ? state.withProperty((IUnlistedProperty)CAMOID, (Object)new CamoBlockId(mimicBlock)) : state;
    }

    @Deprecated
    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        IBlockState block = world.func_180495_p(pos.func_177972_a(side));
        if (block.func_177230_c() instanceof BlockCamouflage) {
            ICamo te = BlockCamouflage.getTE(world, pos);
            ICamo teOther = BlockCamouflage.getTE(world, pos.func_177972_a(side));
            return !te.getCamoBlock().func_177230_c().equals(teOther.getCamoBlock().func_177230_c());
        }
        return true;
    }

    @Deprecated
    public IBlockState func_176203_a(int meta) {
        EnumFacing facing = EnumFacing.func_176731_b((int)meta);
        return this.func_176223_P().func_177226_a((IProperty)BlockOSBase.PROPERTYFACING, (Comparable)facing);
    }

    public int func_176201_c(IBlockState state) {
        int facingbits = BlockCamouflage.getFacing(state).func_176736_b();
        return facingbits;
    }

    @Deprecated
    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing blockFaceClickedOn, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        EnumFacing enumfacing = placer == null ? EnumFacing.NORTH : EnumFacing.func_176733_a((double)placer.field_70177_z);
        return this.func_176223_P().func_177226_a((IProperty)BlockOSBase.PROPERTYFACING, (Comparable)enumfacing);
    }

    public static EnumFacing getFacing(IBlockState state) {
        return (EnumFacing)state.func_177229_b((IProperty)BlockOSBase.PROPERTYFACING);
    }
}

