/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.entity.slime;

import fathertoast.specialmobs.bestiary.BestiaryInfo;
import fathertoast.specialmobs.entity.SpecialMobData;
import fathertoast.specialmobs.entity.slime.Entity_SpecialSlime;
import fathertoast.specialmobs.loot.LootTableBuilder;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.event.ForgeEventFactory;

public class EntityBlackberrySlime
extends Entity_SpecialSlime {
    private static final String TAG_FUSE_TIME = "FuseTime";
    private static final ResourceLocation[] TEXTURES = new ResourceLocation[]{new ResourceLocation(EntityBlackberrySlime.GET_TEXTURE_PATH("blackberry"))};
    public static ResourceLocation LOOT_TABLE;
    private int fuseTime = 0;

    public static BestiaryInfo GET_BESTIARY_INFO() {
        BestiaryInfo info = new BestiaryInfo(0x331133);
        return info;
    }

    public static void BUILD_LOOT_TABLE(LootTableBuilder loot) {
        EntityBlackberrySlime.ADD_BASE_LOOT(loot);
        loot.addCommonDrop("common", "Gunpowder", Items.field_151016_H);
        loot.addUncommonDrop("uncommon", "Slime color", new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.BLACK.func_176767_b()));
    }

    public EntityBlackberrySlime(World world) {
        super(world);
    }

    @Override
    protected EntitySlime getSplitSlime() {
        return new EntityBlackberrySlime(this.field_70170_p);
    }

    @Override
    public ResourceLocation[] getDefaultTextures() {
        return TEXTURES;
    }

    @Override
    protected ResourceLocation func_184647_J() {
        return this.func_189101_db() ? LOOT_TABLE : LootTableList.field_186419_a;
    }

    @Override
    protected void applyTypeAttributes() {
        this.slimeExperienceValue += 2;
    }

    @Override
    protected void adjustTypeAttributesForSize(int size) {
        this.getSpecialData().addAttribute(SharedMonsterAttributes.field_111267_a, 2.0 * (double)size);
    }

    @Override
    public void func_70636_d() {
        if (this.func_70089_S()) {
            EntityLivingBase target = this.func_70638_az();
            if (!this.field_70170_p.field_72995_K && target != null && this.func_70068_e((Entity)target) < (double)(9.0f + ((float)this.func_70809_q() - 1.0f) * 2.0f)) {
                if (this.fuseTime == 0) {
                    this.func_184185_a(SoundEvents.field_187572_ar, 1.0f, 0.5f);
                } else if (this.fuseTime >= 30) {
                    boolean griefing = ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this);
                    this.field_70729_aU = true;
                    this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, (float)this.func_70809_q() + 0.5f, griefing);
                    this.func_70106_y();
                }
                ++this.fuseTime;
                this.getSpecialData().setRenderScale(this.getSpecialData().getRenderScale() + 0.013f);
                this.field_70179_y = 0.0;
                this.field_70159_w = 0.0;
                this.field_70122_E = false;
            } else if (this.fuseTime > 0) {
                --this.fuseTime;
                this.getSpecialData().setRenderScale(this.getSpecialData().getRenderScale() - 0.013f);
                this.field_70179_y = 0.0;
                this.field_70159_w = 0.0;
                this.field_70122_E = false;
            }
        }
        super.func_70636_d();
    }

    @Override
    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        NBTTagCompound saveTag = SpecialMobData.getSaveLocation(tag);
        saveTag.func_74774_a(TAG_FUSE_TIME, (byte)this.fuseTime);
    }

    @Override
    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        NBTTagCompound saveTag = SpecialMobData.getSaveLocation(tag);
        if (saveTag.func_150297_b(TAG_FUSE_TIME, 99)) {
            this.fuseTime = saveTag.func_74771_c(TAG_FUSE_TIME);
        }
    }
}

