/*
 * Decompiled with CFR 0.152.
 */
package ben_mkiv.guitoolkit.client;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.ResourceLocation;

public class SlotIcons {
    private static Map<Integer, ResourceLocation> tiericons;
    private static Map<String, ResourceLocation> sloticons;

    private static void registerSlotTypeIcons() {
        if (sloticons != null) {
            return;
        }
        String[] SLOT_TYPES = new String[]{"card", "component_bus", "container", "cpu", "floppy", "hdd", "memory", "rack_mountable", "tablet", "upgrade", "eeprom", "tool"};
        sloticons = new HashMap<String, ResourceLocation>();
        for (String type : SLOT_TYPES) {
            sloticons.put(type, new ResourceLocation("opencomputers", "textures/icons/" + type + ".png"));
        }
    }

    private static void registerTierIcons() {
        if (tiericons != null) {
            return;
        }
        tiericons = new HashMap<Integer, ResourceLocation>();
        tiericons.put(-1, new ResourceLocation("opencomputers", "textures/icons/na.png"));
        tiericons.put(0, new ResourceLocation("opencomputers", "textures/icons/tier0.png"));
        tiericons.put(1, new ResourceLocation("opencomputers", "textures/icons/tier1.png"));
        tiericons.put(2, new ResourceLocation("opencomputers", "textures/icons/tier2.png"));
    }

    public static ResourceLocation fromTier(int tier) {
        SlotIcons.registerTierIcons();
        if (tiericons.containsKey(tier)) {
            return tiericons.get(tier);
        }
        return null;
    }

    public static ResourceLocation fromSlot(String slot) {
        SlotIcons.registerSlotTypeIcons();
        if (sloticons.containsKey(slot)) {
            return sloticons.get(slot);
        }
        return null;
    }
}

