/*
 * Decompiled with CFR 0.152.
 */
package com.bymarcin.openglasses.surface;

import ben_mkiv.commons0815.utils.utilsCommon;
import ben_mkiv.rendertoolkit.client.thermalvision.ShaderHelper;
import ben_mkiv.rendertoolkit.common.widgets.IRenderableWidget;
import ben_mkiv.rendertoolkit.common.widgets.RenderType;
import ben_mkiv.rendertoolkit.common.widgets.Widget;
import ben_mkiv.rendertoolkit.common.widgets.component.world.EntityTracker3D;
import ben_mkiv.rendertoolkit.surface.ClientSurface;
import com.bymarcin.openglasses.OpenGlasses;
import com.bymarcin.openglasses.item.GlassesNBT;
import com.bymarcin.openglasses.item.OpenGlassesItem;
import com.bymarcin.openglasses.item.upgrades.UpgradeItem;
import com.bymarcin.openglasses.network.NetworkRegistry;
import com.bymarcin.openglasses.network.packet.GlassesEventPacket;
import com.bymarcin.openglasses.surface.StaticWidgets;
import com.bymarcin.openglasses.utils.GlassesInstance;
import com.bymarcin.openglasses.utils.OpenGlassesHostClient;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.vecmath.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class OCClientSurface
extends ClientSurface {
    public static boolean thermalActive = false;
    public static GlassesInstance glasses;
    private static HashMap<UUID, OpenGlassesHostClient> hosts;
    private int updateTicks = 10;

    public static OCClientSurface instance() {
        return (OCClientSurface)instances;
    }

    public OpenGlassesHostClient getHost(UUID hostUUID) {
        if (!hosts.containsKey(hostUUID)) {
            hosts.put(hostUUID, new OpenGlassesHostClient(hostUUID));
        }
        return hosts.get(hostUUID);
    }

    public Collection<OpenGlassesHostClient> getHosts() {
        return hosts.values();
    }

    public Vec3d getRenderResolution(UUID hostUUID) {
        return hostUUID != null ? OCClientSurface.glasses.getHost((UUID)hostUUID).renderResolution : super.getRenderResolution(null);
    }

    public void setRenderResolution(Vec3d resolution, UUID instanceUUID) {
        if (instanceUUID != null) {
            OCClientSurface.glasses.getHost((UUID)instanceUUID).renderResolution = resolution;
        } else {
            super.setRenderResolution(resolution, instanceUUID);
        }
    }

    public void onLeave() {
        hosts.clear();
        this.initLocalGlasses(ItemStack.field_190927_a);
    }

    public void initLocalGlasses(ItemStack glassesStack) {
        glasses = new GlassesInstance(glassesStack.func_77946_l());
    }

    public void sendResolution() {
        if (glasses.get().func_190926_b()) {
            return;
        }
        for (UUID hostUUID : glasses.getHosts().keySet()) {
            NetworkRegistry.packetHandler.sendToServer((IMessage)new GlassesEventPacket(hostUUID, GlassesEventPacket.EventType.GLASSES_SCREEN_SIZE, resolution.func_78326_a(), resolution.func_78328_b(), resolution.func_78325_e()));
        }
    }

    public void renderOverlay(float partialTicks) {
        if (!this.shouldRenderStart(RenderType.GameOverlayLocated)) {
            return;
        }
        OCClientSurface.preRender((RenderType)RenderType.GameOverlayLocated, (float)partialTicks);
        GlStateManager.func_179132_a((boolean)false);
        for (GlassesInstance.HostClient host : glasses.getHosts().values()) {
            if (!host.renderOverlay) continue;
            GlStateManager.func_179094_E();
            Vec3d renderResolution = this.getRenderResolution(host.uuid);
            if (!renderResolution.equals((Object)vec3d000)) {
                GlStateManager.func_179139_a((double)((double)resolution.func_78326_a() / renderResolution.field_72450_a), (double)((double)resolution.func_78328_b() / renderResolution.field_72448_b), (double)1.0);
            }
            this.renderWidgets(host.getHost().getWidgetsOverlay().values(), partialTicks, vec3d000, host.getHost());
            GlStateManager.func_179121_F();
        }
        OCClientSurface.postRender((RenderType)RenderType.GameOverlayLocated);
    }

    public void renderWorld(float partialTicks) {
        this.updateThermalVision();
        if (!this.shouldRenderStart(RenderType.WorldLocated)) {
            return;
        }
        OCClientSurface.preRender((RenderType)RenderType.WorldLocated, (float)partialTicks);
        GlStateManager.func_179132_a((boolean)true);
        for (GlassesInstance.HostClient host : glasses.getHosts().values()) {
            if (!host.renderWorld || host.getHost().absoluteRenderPosition && !OCClientSurface.glasses.getConditions().hasNavigation) continue;
            GlStateManager.func_179094_E();
            Vec3d renderPos = host.getHost().getRenderPosition(partialTicks);
            if (!host.getHost().absoluteRenderPosition) {
                GlStateManager.func_179137_b((double)renderPos.field_72450_a, (double)renderPos.field_72448_b, (double)renderPos.field_72449_c);
            }
            this.renderWidgets(host.getHost().getWidgetsWorld().values(), partialTicks, renderPos, host.getHost());
            GlStateManager.func_179121_F();
        }
        OCClientSurface.postRender((RenderType)RenderType.WorldLocated);
        GlStateManager.func_179126_j();
    }

    private void updateThermalVision() {
        if (this.updateTicks % 10 != 0 || glasses.get().func_190926_b()) {
            return;
        }
        if (OCClientSurface.glasses.thermalVisionActive != thermalActive) {
            if (OCClientSurface.glasses.thermalVisionActive) {
                ShaderHelper.loadOutlineShader((ShaderHelper.ShaderType)ShaderHelper.ShaderType.THERMAL_VISION);
            } else {
                ShaderHelper.loadOutlineShader((ShaderHelper.ShaderType)ShaderHelper.ShaderType.VANILLA_GLOW);
            }
            thermalActive = OCClientSurface.glasses.thermalVisionActive;
        }
    }

    public static Vec3d getEntityLocation(Entity entityIn, float partialTicks) {
        if (entityIn == null) {
            return new Vec3d(0.0, 0.0, 0.0);
        }
        double[] location = OCClientSurface.getEntityPlayerLocation((Entity)entityIn, (float)partialTicks);
        return new Vec3d(location[0], location[1], location[2]);
    }

    private void renderWidgets(Collection<IRenderableWidget> widgets, float partialTicks, Vec3d renderPos, OpenGlassesHostClient host) {
        long renderConditions = glasses.getConditions().get();
        Vector3f offset = new Vector3f((float)renderPos.field_72450_a, (float)renderPos.field_72448_b, (float)renderPos.field_72449_c);
        for (IRenderableWidget renderable : widgets) {
            if ((!host.absoluteRenderPosition ? !renderable.shouldWidgetBeRendered((EntityPlayer)Minecraft.func_71410_x().field_71439_g, offset) : !this.shouldAbsoluteWidgetBeRendered((EntityPlayer)Minecraft.func_71410_x().field_71439_g, offset, renderable)) || !renderable.isWidgetOwner(OCClientSurface.glasses.getHost((UUID)host.hostUUID).ownerUUID.toString())) continue;
            if (renderable instanceof EntityTracker3D.RenderEntityTracker) {
                OCClientSurface.renderWidget((IRenderableWidget)renderable, (long)renderConditions, (Vec3d)renderPos.func_186678_a(-1.0));
                continue;
            }
            OCClientSurface.renderWidget((IRenderableWidget)renderable, (long)renderConditions);
        }
    }

    private boolean shouldAbsoluteWidgetBeRendered(EntityPlayer player, Vector3f offset, IRenderableWidget renderable) {
        RayTraceResult pos;
        if (!utilsCommon.inRange((Entity)Minecraft.func_71410_x().field_71439_g, (Vec3d)new Vec3d((double)offset.x, (double)offset.y, (double)offset.z), (double)viewDistance)) {
            return false;
        }
        if (renderable.isLookingAtEnabled() && (pos = ClientSurface.getBlockCoordsLookingAt((EntityPlayer)player)) != null && !pos.func_178782_a().equals((Object)new BlockPos(renderable.lookingAtVector()))) {
            return false;
        }
        return renderable.isVisible();
    }

    public boolean shouldRenderStart(RenderType renderEvent) {
        if (this.getWidgetCount(null, renderEvent) < 1) {
            return false;
        }
        ItemStack renderGlasses = glasses.get().func_77946_l();
        if (renderGlasses.func_190926_b()) {
            return false;
        }
        if (OpenGlassesItem.getEnergyStored(renderGlasses) == 0.0) {
            if (renderEvent.equals((Object)RenderType.GameOverlayLocated) && StaticWidgets.noPowerRender != null) {
                OCClientSurface.preRender((RenderType)renderEvent, (float)-1.0f);
                GlStateManager.func_179132_a((boolean)false);
                OCClientSurface.renderWidget((IRenderableWidget)StaticWidgets.noPowerRender, (long)-1L);
                OCClientSurface.postRender((RenderType)RenderType.GameOverlayLocated);
            }
            return false;
        }
        if (this.getWidgetCount(null, renderEvent) > renderGlasses.func_77978_p().func_74762_e("widgetLimit")) {
            if (renderEvent.equals((Object)RenderType.GameOverlayLocated) && StaticWidgets.widgetLimitRender != null) {
                OCClientSurface.preRender((RenderType)renderEvent, (float)-1.0f);
                GlStateManager.func_179132_a((boolean)false);
                OCClientSurface.renderWidget((IRenderableWidget)StaticWidgets.widgetLimitRender, (long)-1L);
                OCClientSurface.postRender((RenderType)RenderType.GameOverlayLocated);
            }
            return false;
        }
        if (glasses.getHosts().size() == 0) {
            if (renderEvent.equals((Object)RenderType.GameOverlayLocated) && StaticWidgets.noLinkRender != null) {
                OCClientSurface.preRender((RenderType)renderEvent, (float)-1.0f);
                GlStateManager.func_179132_a((boolean)false);
                OCClientSurface.renderWidget((IRenderableWidget)StaticWidgets.noLinkRender, (long)-1L);
                OCClientSurface.postRender((RenderType)RenderType.GameOverlayLocated);
            }
            return false;
        }
        return true;
    }

    public void updateWidgets(UUID hostUUID, Set<Map.Entry<Integer, Widget>> widgets) {
        if (hostUUID != null) {
            OCClientSurface.instance().getHost(hostUUID).updateWidgets(widgets);
        }
    }

    public void removeWidgets(UUID hostUUID, List<Integer> ids) {
        if (hostUUID != null) {
            this.getHost(hostUUID).removeWidgets(ids);
        }
    }

    public void removeAllWidgets(UUID hostUUID) {
        if (hostUUID != null) {
            hosts.get(hostUUID).removeAllWidgets();
        }
    }

    public int getWidgetCount(UUID hostUUID, RenderType renderEvent) {
        if (hostUUID != null) {
            return this.getHost(hostUUID).getWidgetCount(renderEvent);
        }
        int count = 0;
        for (OpenGlassesHostClient host : hosts.values()) {
            count += host.getWidgetCount(renderEvent);
        }
        return count;
    }

    public void equipmentChanged(ItemStack newStack) {
        ItemStack glassesStackBaubles;
        if (!(OpenGlasses.isGlassesStack(newStack) || glasses.get().func_190926_b() || (glassesStackBaubles = OpenGlasses.getGlassesStack((EntityPlayer)Minecraft.func_71410_x().field_71439_g)).func_190926_b())) {
            newStack = glassesStackBaubles;
        }
        if (newStack.func_190926_b()) {
            if (!glasses.get().func_190926_b()) {
                this.initLocalGlasses(ItemStack.field_190927_a);
            }
        } else if (OpenGlasses.isGlassesStack(newStack) && !GlassesNBT.getUniqueId(newStack).equals(glasses.getUniqueId())) {
            this.initLocalGlasses(newStack);
        }
    }

    public void update(EntityPlayer player) {
        glasses.refreshConditions();
        if (this.updateTicks % 20 == 0) {
            ItemStack glassesStack = OpenGlasses.getGlassesStack(player);
            if (!glasses.get().equals(glassesStack)) {
                this.equipmentChanged(OpenGlasses.getGlassesStack(player));
            }
            this.updateTicks = 0;
        }
        if (!glasses.get().func_190926_b()) {
            for (UpgradeItem upgrade : OpenGlassesItem.upgrades) {
                upgrade.updateClient(player, glasses.get());
            }
        }
        ++this.updateTicks;
    }

    static {
        instances = new OCClientSurface();
        glasses = new GlassesInstance(ItemStack.field_190927_a);
        hosts = new HashMap();
    }
}

